/***********************************************************************
*
* darts umenu.c -- Version 3.0 
*
* Copyright (c)
* Apple Computer, Inc.  1986-1990
* All Rights Reserved.
*
* Developer Technical Support Apple II Sample Code
*
* This file contains the code which implements 
* menus in the program.
*
***********************************************************************/

#include <types.h>
#include <desk.h>
#include <intmath.h>
#include <menu.h>
#include <quickdraw.h>
#include <window.h>
#include "darts.h"


extern unsigned int     crickettTables[NumPlayers][26], score[NumPlayers];
extern unsigned int     gameType, quitFlag, weHaveAWinner;
extern GrafPortPtr      theWindow;
extern WmTaskRec        event;



/************************************************************************************
*
* doAboutItem
*
* Calls AlertWindow to display the about box.  The result is ignored.
*
************************************************************************************/
void    doAboutItem()
{
    AlertWindow(refIsResource * 2, NULL, 0x0001L);
}



/************************************************************************************
*
* doNewItem
*
* Inits the current window for a new game.  Can be called in response to a 
* menu selection or button press.
*
************************************************************************************/
void    doNewItem()
{
    unsigned int    j, k;
    unsigned long   along;

    score[Player1] = 0;
    score[Player2] = 0;
    
    invalScore(Player1);
    invalScore(Player2);

    clearList(Player1);
    clearList(Player2);
    
    for (k = 0; k < NumPlayers; k++) {
        for (j = 15; j < 26; j++) {
            crickettTables[k][j] = 0;
        }
    }

    if (gameType == 1) {
        for (k = 25; k >= 15; k--) {
            fixButtonTitle(Player1, k);
            fixButtonTitle(Player2, k);
            if (k == 25) k = 21;
        }
    }

    weHaveAWinner = 0;
}



/************************************************************************************
*
* doQuitItem
*
* Sets the global done flag to true in response to the quit menu time.  Can 
* also be called in reponse to the quit button.
*
************************************************************************************/
void    doQuitItem()
{
    quitFlag++;
}



/***********************************************************************************
*
* doSwitchGames
*
* Switches from Robin to Crickett and back again.  This is called in response
* to selections in the Game menu.  Note:  that if the selected item is
* the current game, then nothing happens.
*
***********************************************************************************/
void            doSwitchGames(itemNum)
unsigned int    itemNum;
{
    if (itemNum == RobinGameItem) itemNum = 0;
    else itemNum = 1;

    if (gameType != itemNum) {
        CloseWindow(theWindow);
        if (!itemNum) startupRobinGame();
        else startupCrickettGame();
        gameType = itemNum;
        doNewItem();
    }
}



/************************************************************************************
*
* doMenu
*
* This resonds to menu selections.  It is called by main event loop in 
* response to all menu selctions (mouse and keyboard).
*
************************************************************************************/
void    doMenu()
{
    unsigned int    menuNum, itemNum;

    menuNum = HiWord (event.wmTaskData);
    itemNum = LoWord (event.wmTaskData);

    switch(itemNum) {
        case AboutItem:
            doAboutItem();
            break;
        case NewItem:
            doNewItem();
            break;
        case QuitItem:
            doQuitItem();
            break;
        case UndoItem:
        case CutItem:
        case CopyItem:
        case PasteItem:
        case ClearItem:
            break;
        case RobinGameItem:
        case CrickettGameItem:
            doSwitchGames(itemNum);
            break;
    }

    HiliteMenu(0 ,menuNum);     /*Unhighlight the menu title*/
}



/************************************************************************************
*
* setupMenus
*
* Creates the system menu bar with desk accessories.
*
************************************************************************************/
void    setupMenus()
{
    SetSysBar(NewMenuBar2(refIsResource, 0x0001L, NULL));
    SetMenuBar(NULL);
    
    FixAppleMenu(AppleMenuID);          /* Add DAs to apple menu     */
    FixMenuBar();                       /* Set sizes of menus        */
    DrawMenuBar();                      /* ...and draw the menu bar! */
}
